<?php
class BotTelegram {
    private $botToken; // Token API Bot Telegram
    private $chatId;   // ID chat tujuan (bisa admin atau user)

    public function __construct($conn) {
        // Ambil data dari database
        $sql_2 = mysqli_query($conn, "SELECT * FROM `tb_apitelegram` WHERE cuid = 1") or die(mysqli_error($conn));
        $s2 = mysqli_fetch_array($sql_2);

        // Pastikan data ditemukan sebelum menggunakannya
        if ($s2) {
            $this->botToken = $s2['token'];
            $this->chatId = $s2['owner'];
        } else {
            die("Error: Data API Telegram tidak ditemukan di database.");
        }
    }

    public function sendToTelegram($message) {
        $url = "https://api.telegram.org/bot{$this->botToken}/sendMessage";

        // Siapkan data POST
        $data = array(
            'chat_id' => $this->chatId,
            'text' => $message,
        );

        // Kirim permintaan
        return $this->sendRequest($url, 'POST', $data);
    }

    private function sendRequest($url, $method, $data) {
        $ch = curl_init();

        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => http_build_query($data), // Konversi array ke query string
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
            ),
        ));

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            curl_close($ch);
            return "CURL Error: " . $error_msg; // Kembalikan pesan error jika ada
        }

        curl_close($ch);

        // Periksa respons dari API Telegram
        $responseData = json_decode($response, true);
        if (isset($responseData['ok']) && $responseData['ok'] === true) {
            return "Pesan berhasil dikirim.";
        } else {
            return "Gagal mengirim pesan: " . ($responseData['description'] ?? 'Unknown error');
        }
    }
}
