<?php
ob_start();
session_start();
date_default_timezone_set("Asia/Jakarta");
include('../config/koneksi.php');
//include('security/index.php');

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        session_unset();
        session_destroy();
        $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Sesi tidak Valid!'];
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));

    if ($_POST['captcha_input'] != $_SESSION['captcha_code']) {
        $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Captcha Salah!'];
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $last_login = date('Y-m-d H:i:s');
    $user = filter_input(INPUT_POST, 'user', FILTER_SANITIZE_STRING);
    $pass = filter_input(INPUT_POST, 'pass', FILTER_SANITIZE_STRING);

    if (empty($user) || empty($pass)) {
        $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Username atau password salah!'];
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }

    $stmt = $conn->prepare("SELECT cuid, pass, level FROM `tb_user` WHERE user = ?");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();

    if ($result->num_rows > 0) {
        $user_data = $result->fetch_array(MYSQLI_ASSOC);
        $token = insertToken($user_data['cuid']);
        $password = $user_data['pass'];

        if (password_verify($pass, $password)) {
            $userID = $user_data['cuid'];
            $_SESSION['user'] = htmlspecialchars($user);
            $_SESSION['token'] = $token;

            if ($user_data['level'] == 'user') {
                $_SESSION['user'] = '';
                unset($_SESSION['user']);
                session_destroy();
                $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Level user tidak di izinkan login!'];
                header('Location: ' . $_SERVER['HTTP_REFERER']);
                exit;
            } else {
                session_regenerate_id(true);
                $update = $conn->prepare("UPDATE `tb_user` SET last_login = ? WHERE user = ?");
                $update->bind_param("ss", $last_login, $_SESSION['user']);
                $update->execute();
                $update->close();
                header('location:../dashboard/');
            }
        } else {
            session_destroy();
            $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Level user tidak di izinkan login!'];
            header('Location: ' . $_SERVER['HTTP_REFERER']);
            exit;
        }
    } else {
        $_SESSION['notif'] = ['type' => 'warning', 'message' => 'User tidak ada'];
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }
} else {
    $_SESSION['notif'] = ['type' => 'warning', 'message' => 'Metode tak di ijinkan!'];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}

function insertToken($user_id = 0)
{
    global $conn;
    if (empty($user_id) && $user_id === 0) {
        return false;
    }

    $token = generateToken();

    $stmt = $conn->prepare("INSERT INTO tb_token (token) VALUES (?)");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $token_id = $stmt->insert_id;
    $stmt->close();

    $stmt = $conn->prepare("UPDATE tb_user SET token_id = ? WHERE cuid = ?");
    $stmt->bind_param("ii", $token_id, $user_id);
    $stmt->execute();
    $stmt->close();

    return $token;
}

function generateToken()
{
    $length = 10;
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }

    $token = password_hash(microtime(true) . $randomString, PASSWORD_DEFAULT);
    return $token;
}
