<?php 
include('session.php');
include('security/index.php');
$csrf_token = bin2hex(random_bytes(32));
$_SESSION['csrf_token'] = $csrf_token;
if($u['cuid'] == '1'){
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Folder penyimpanan gambar
    $target_dir = "../uploadsimagelink/";
    
    // Cek apakah folder ada, jika tidak buat folder
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0755, true);
    }
    
    // Nama file dan path target
    $file_name = basename($_FILES["image"]["name"]);
    $target_file = $target_dir . uniqid() . "_" . $file_name;

    // Cek tipe file
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];

    // Validasi file
    if (!in_array($imageFileType, $allowed_types)) {
        $_SESSION['upload'] = [
            'type' => 'alert alert-danger alert-sm',
            'message' => 'Hanya file JPG, JPEG, PNG, dan GIF yang diperbolehkan.'
        ];
    } elseif ($_FILES["image"]["size"] > 5000000) { // Maksimal ukuran 5MB
        $_SESSION['upload'] = [
            'type' => 'alert alert-danger alert-sm',
            'message' => 'Ukuran file terlalu besar. Maksimal 5MB.'
        ];
    } else {
        // Coba upload file
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $_SESSION['upload'] = [
                'type' => 'alert alert-success alert-sm',
                'message' => 'Gambar berhasil diupload. <a href="' . $target_file . '" target="_blank">Salin Link: ' . $target_file . '</a>'
            ];
        } else {
            $_SESSION['upload'] = [
                'type' => 'alert alert-danger alert-sm',
                'message' => 'Terjadi kesalahan saat mengupload file.'
            ];
        }
    }
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}
}
?>
<?php if($u['cuid'] == '1'){ ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Gambar</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <?php
        // Tampilkan notifikasi jika ada
        if (isset($_SESSION['upload'])) {
            echo '<div class="' . $_SESSION['upload']['type'] . '">' . $_SESSION['upload']['message'] . '</div>';
            unset($_SESSION['upload']); // Hapus notifikasi setelah ditampilkan
        }
        ?>
        <form action="" method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="image" class="form-label">Pilih Gambar</label>
                <input type="file" name="image" id="image" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Upload</button>
            <a href="<?php echo $urlweb; ?>/dashboard/" class="btn btn-danger">Kembali</a>
        </form>
    </div>
</body>
</html>
<?php } ?>