<!-- Menu Navigasi Bawah -->
<nav class="navbar navbar-expand fixed-bottom navbar-footer px-0">
  <ul class="navbar-nav nav-justified w-100">

    <!-- History -->
    <li class="nav-item">
      <a class="nav-link small text-truncate d-flex flex-column" href="app/history">
        <i class="fas fa-2x fa-history mb-1"></i>
        History
      </a>
    </li>

    <!-- Deposit -->
    <li class="nav-item">
      <a class="nav-link small text-truncate d-flex flex-column" href="app/deposit">
        <i class="fas fa-2x fa-download mb-1"></i>
        Deposit
      </a>
    </li>

    <!-- Withdraw -->
    <li class="nav-item">
      <a class="nav-link small text-truncate d-flex flex-column" href="app/withdraw">
        <i class="fas fa-2x fa-upload mb-1"></i>
        Withdraw
      </a>
    </li>

    <!-- Promo -->
    <li class="nav-item">
      <a class="nav-link small text-truncate d-flex flex-column text-promo" href="javascript:void(0)">
        <i class="fag fa-2x fa-promotion mb-1"></i>
        Promo
      </a>
    </li>

    <!-- Live Chat -->
    <li class="nav-item dropup">
      <a class="nav-link small text-truncate d-flex flex-column text-live-chat dropdown-toggle" data-toggle="dropdown" href="#">
        <i class="fas fa-2x fa-headset mb-1"></i>
        Live Chat
      </a>
      <div class="dropdown-menu w-100 bg-primary-custom border border-theme-dark">
        <a class="nav-link small text-truncate d-flex flex-column text-theme" href="https://direct.lc.chat/6379021/" target="_blank" rel="nofollow">
          <i class="fas fa-3x fa-comments mb-1"></i>
          Live Chat
        </a>
      </div>
    </li>

  </ul>
</nav>

<!-- Deposit Modal -->
<div class="modal fade bottom-sheet" id="modalDeposit" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable">
    <div class="modal-content w-100">
      <div class="modal-header px-3 py-2">
        <h6 class="modal-title">
          <i class="fas fa-download mr-2"></i> DEPOSIT
        </h6>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" id="depositModalBody">
        <div class="text-center py-4">
          <div class="spinner-border text-success" role="status">
            <span class="sr-only">Loading...</span>
          </div>
          <div>Memuat form deposit...</div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- JS: Load Deposit Form -->
<script>
  function loadDepositForm() {
    document.getElementById('depositModalBody').innerHTML = `
      <div class="text-center py-4">
        <div class="spinner-border text-success" role="status">
          <span class="sr-only">Loading...</span>
        </div>
        <div>Memuat form deposit...</div>
      </div>
    `;

    fetch('app/pages/deposit.php')
      .then(response => {
        if (!response.ok) throw new Error('Gagal load');
        return response.text();
      })
      .then(html => {
        document.getElementById('depositModalBody').innerHTML = html;
      })
      .catch(error => {
        console.error('Load form gagal:', error);
        document.getElementById('depositModalBody').innerHTML = `
          <div class="alert alert-danger text-center mb-0">
            Gagal memuat form deposit.
          </div>
        `;
      });
  }
</script>
