<?php
require_once('session.php');

// Ambil data dari POST
$metode = htmlspecialchars(strip_tags(trim($_POST['metode'] ?? '')), ENT_QUOTES, 'UTF-8');
$nominal = preg_replace('/[^0-9]/', '', $_POST['nominal']); // Validasi hanya angka

if (!$nominal || $nominal < 50000) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Nominal tidak valid atau kurang dari minimum Rp50,000.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Ambil data bank
$getBank = mysqli_query($conn, "SELECT * FROM `tb_bank` WHERE userID = '$userID'") or die(mysqli_error($conn));
$gb = mysqli_fetch_array($getBank);
$catatan = $gb ? $gb['akun'] . ' ' . $gb['no_rek'] . ' a/n ' . $gb['pemilik'] : 'Informasi bank tidak ditemukan.';

// Ambil saldo aktif
$cekBalance = mysqli_query($conn, "SELECT * FROM `tb_balance` WHERE userID = '$userID'") or die(mysqli_error($conn));
$cb = mysqli_fetch_array($cekBalance);
$saldoAktif = $cb['active'] ?? 0;

if ($saldoAktif < $nominal) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Saldo Anda tidak mencukupi untuk melakukan withdraw.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Cek transaksi pending
$cekTransaksi = mysqli_query($conn, "SELECT * FROM `tb_transaksi` WHERE jenis = 2 AND userID = '$userID' AND status = 0") or die(mysqli_error($conn));
if (mysqli_num_rows($cekTransaksi) > 0) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Anda masih memiliki transaksi withdraw yang belum selesai.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Ambil data user eksternal
$cek_usernya = mysqli_query($conn, "SELECT * FROM tb_user WHERE cuid = '$userID'") or die(mysqli_error($conn));
$data_usernya = mysqli_fetch_array($cek_usernya);
$username = $data_usernya['extplayer'] ?? null;

if (!$username) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Username eksternal tidak ditemukan. Harap periksa akun Anda.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Kurangi saldo melalui API eksternal
$sql_255 = mysqli_query($conn, "SELECT * FROM `tb_apigames` WHERE cuid = 1") or die(mysqli_error($conn));
$s255 = mysqli_fetch_array($sql_255);

if (!$s255) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Konfigurasi API tidak ditemukan. Silakan coba lagi nanti.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

$token = $s255['token'];
$owner = $s255['owner'];
$endpoint = $s255['endpoint'];

// Panggil API untuk withdraw
$api = new CxfteamsApi($token, $owner, $endpoint);
$withdrawBalanceResponse = $api->withdrawBalance($username, $nominal);

if (!$withdrawBalanceResponse) {
    $_SESSION['withdraw'] = [
        'type' => 'alert alert-warning alert-sm',
        'message' => 'Gagal melakukan withdraw melalui API. Silakan coba lagi nanti.'
    ];
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit();
}

// Kirim notifikasi ke Telegram
$message = "Ada permintaan withdraw\n\n";
$message .= "Nominal : Rp" . number_format($nominal) . "\n";
$message .= "Id pengirim : " . $username;
$botApi = new BotTelegram($conn);
$botApi->sendToTelegram($message);

// Buat kode transaksi
$kode_unik = substr(str_shuffle('1234567890'), 0, 3);
$kd_transaksi = date('Ymds') . $kode_unik;
$created_date = date('Y-m-d H:i:s');

// Insert transaksi ke database
$insert_transaksi = mysqli_query($conn, "INSERT INTO `tb_transaksi` 
    (`kd_transaksi`, `date`, `transaksi`, `total`, `saldo`, `note`, `gameid`, `providerID`, `jenis`, `metode`, `pay_from`, `userID`, `status`) 
    VALUES 
    ('$kd_transaksi', '$created_date', 'Penarikan Dana', '$nominal', 0, '$catatan', '', '0', '2', '$metode', '0', '$userID', 0)")
    or die(mysqli_error($conn));

// Set notifikasi sukses
$_SESSION['withdraw'] = [
    'type' => 'alert alert-success alert-sm',
    'message' => 'Withdraw berhasil diproses. Silakan tunggu konfirmasi.'
];
header('Location: ' . $_SERVER['HTTP_REFERER']);
exit();
